	function PLOT_FIR_SPEC(Be, D, dSpec, opt);
 
	%	opt: for magnutude: 'Mag' or 'mag' else attenuation specification
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	%	Author: 			Lars Wanhammar 2005-05-07
	%	Modified by: 	 	
	% 	Copyright:			by authors - not released for commercial use
	%	Version:			1 
	%	Known bugs:			Multiband and Attenuation Need testing!
	%	Report bugs to:		Wanhammar@gmail.com
 
	color = [0.7 0.7 0.7]; % Gray
	if strcmp(opt,'mag')|strcmp(opt,'Mag')
		c = -1; 	% Plot magnitude function
	else 
		c = 1;		% Plot attenuation
	end
	V = axis;
	n = 1;
	x = min(dSpec);
	yminaxis = -(floor(log10((1+x)/x))+2)*20;
	for b = 2:2:length(Be)
		lc = Be(b-1)*V(2)/pi;
		rc = Be(b)*V(2)/pi;
		if D(b) == 1
			Amaxreq = c*H_2_MAG((1+dSpec(n))/(1-dSpec(n)));
			if strcmp(opt,'mag')|strcmp(opt,'Mag') % Plot magnitude function
				patch([lc rc rc lc lc], [Amaxreq Amaxreq V(3) V(3) Amaxreq], color); 
			else % Plot attenuation
				patch([lc rc rc lc lc], [Amaxreq Amaxreq -yminaxis -yminaxis Amaxreq], color); 
			end 
		else
			dSpecmax = max(dSpec);
			Aminreq = c*H_2_MAG((1+dSpecmax)/dSpec(n));
			patch([lc rc rc lc lc], [0 0 Aminreq Aminreq 0], color);
		end
		n = n + 1;
	end
